<!DOCTYPE html>
<html lang="{{ app()->getLocale() }}">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>@lang('emails.email_verification.title')</title>
</head>
<body style="margin: 0; padding: 0; font-family: Arial, sans-serif;">
    <div class="email-block" style="width: 100%; max-width: 700px; margin: 0 auto;">
        <div class="email-banner" style="position: relative; max-height: 524px;">
            <img class="e-logo" src="{{ asset('frontend/images/logo.png') }}" alt="@lang('emails.email_verification.company_logo_alt')" style="position: absolute; left: 50%; top: 27px; transform: translateX(-50%); width: 100%; max-width: 240px; z-index:99;">
            <img src="{{ asset('frontend/images/banner2.png') }}" alt="@lang('emails.email_verification.banner_alt')" style="width: 100%; max-width: 100%;">
        </div>
        
        <div class="email-body" style="padding: 50px 30px; background-color: #ffffff;">
            <h2 style="font-family: Arial; font-weight: 700; font-size: 24px; line-height: 100%; text-align: center; margin: 0;">
                @lang('emails.email_verification.verify_your_email')
            </h2>
            
            <p style="font-family: Arial; font-weight: 400; font-size: 16px; line-height: 24px; text-align: center; margin: 30px 0px; color: #111111;">
                <b>@lang('emails.email_verification.hello', ['name' => $name])</b>
            </p>
            
            <p style="font-family: Arial; font-weight: 400; font-size: 16px; line-height: 24px; color: #111111; margin-bottom: 20px;">
                @lang('emails.email_verification.click_to_verify')
            </p>
            
            <div style="text-align: center; margin-bottom: 30px;">
                <a href="{{ $verificationUrl }}" style="text-decoration: none; font-weight: 400; font-size: 16px; line-height: 100%; vertical-align: middle; text-transform: uppercase; padding: 13px 18px; background: #5BC0DE; border-radius: 4px; color: #fff; display: inline-block;">
                    @lang('emails.email_verification.verify_email_button')
                </a>
            </div>
            
            <p style="font-family: Arial; font-weight: 400; font-size: 16px; line-height: 24px; color: #111111;">
                @lang('emails.email_verification.ignore_if_not_registered')
            </p>
            
            <p style="font-family: Arial; font-weight: 400; font-size: 16px; line-height: 24px; color: #000000; margin-top: 30px;">
                @lang('emails.email_verification.contact_customer_service') 
                <a href="mailto:cs@dachboxit.de" style="color: #000000; text-decoration: underline;">cs@dachboxit.de</a>.<br><br>
                @lang('emails.email_verification.best_regards')<br>
                @lang('emails.email_verification.team_signature')
            </p>
        </div>
        
        <div class="email-footer" style="padding: 31px 45px 81px; background: #111111; display: flex; justify-content: center; align-items: center; flex-direction: column; gap: 30px; border-bottom: 1px solid #383838;">
            <img src="{{ asset('frontend/images/logo.png') }}" alt="@lang('emails.email_verification.company_logo_alt')" style="max-width: 240px;">
            
            <p style="font-family: Arial; font-weight: 400; font-size: 15px; line-height: 24px; text-align: center; color: #fff;">
                @lang('emails.email_verification.footer_help_text')
            </p>
            
            <div class="e-social" style="display: flex; gap: 10px; align-items: flex-start;">
                <div class="e-s-list" style="display: flex; flex-direction: column; align-items: center; gap: 10px;">
                    <img src="{{ asset('frontend/images/Message.png') }}" alt="@lang('emails.email_verification.email_icon_alt')" style="width: 20px; height: 20px; object-fit: contain;">
                    <p style="font-family: Arial; font-weight: 400; font-size: 14px; line-height: 24px; text-align: center; color: #fff;">
                        cs@dachboxit.de
                    </p>
                </div>
                <div class="e-s-list" style="display: flex; flex-direction: column; align-items: center; gap: 10px;">
                    <img src="{{ asset('frontend/images/Mobile1.png') }}" alt="@lang('emails.email_verification.phone_icon_alt')" style="width: 20px; height: 20px; object-fit: contain;">
                    <p style="font-family: Arial; font-weight: 400; font-size: 14px; line-height: 24px; text-align: center; color: #fff;">
                        +4915172876293
                    </p>
                </div>
            </div>
            
            <p>
                <a href="{{ url('/gdpr') }}" style="font-family: Arial; font-weight: 400; font-size: 14px; line-height: 24px; text-align: center; color: #fff; text-decoration: none;">
                    @lang('emails.email_verification.privacy_policy')
                </a> 
                |
                <a href="{{ url('/term-condition') }}" style="font-family: Arial; font-weight: 400; font-size: 14px; line-height: 24px; text-align: center; color: #fff; text-decoration: none;">
                    @lang('emails.email_verification.terms_conditions')
                </a>
            </p>
            
            <p style="font-family: Arial; font-weight: 400; font-size: 14px; line-height: 24px; text-align: center; color: #fff;">
                @lang('emails.email_verification.company_address')<br>
                @lang('emails.email_verification.tax_id')
            </p>
        </div>
        
        <div class="copy-right" style="background-color: #111111; padding: 15px 30px;">
            <p style="font-family: Arial; font-weight: 400; font-size: 14px; line-height: 24px; text-align: center; color: #fff;">
                @lang('emails.email_verification.copyright', ['year' => date('Y'), 'company_name' => $admin->company_name ?? 'Dachboxit'])
            </p>
        </div>
    </div>
</body>
</html>